/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.entity.hijacked;

import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import energon.srpextra.config.SRPEConfigMobs;
import energon.srpextra.encyclopedia.ParasiteDataHandler;
import energon.srpextra.encyclopedia.data.ParasiteDataBase;
import energon.srpextra.entity.IEData;
import energon.srpextra.entity.ai.SRPEAI_CreeperSwell;
import energon.srpextra.entity.ai.SRPEAI_Swimming;
import energon.srpextra.entity.hijacked.SRPEPHijacked;
import energon.srpextra.init.SRPEItems;
import energon.srpextra.init.SRPESounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHiCreeper
extends SRPEPHijacked
implements IEData {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityHiCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityHiCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityHiCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EXDeath = EntityDataManager.func_187226_a(EntityHiCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime2;
    private int timeSinceIgnited2;
    private int fuseTime2 = SRPEConfigMobs.fuseTimeHijackedCreeper;
    public float hpAnimation = 0.5f;
    private boolean cDeath = true;
    private boolean ex = true;
    public int tick = 0;

    public EntityHiCreeper(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.7f);
        this.canModRender = 1;
        this.type = (byte)11;
    }

    @Override
    public ParasiteDataBase getData() {
        return ParasiteDataHandler.HI_CREEPER;
    }

    @Override
    public int canSpawnByIDData() {
        return this.getData().getCountNaturalTransformForPhaseSpawn();
    }

    @Override
    public int getParasiteIDRegister() {
        return this.getData().parasiteId;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
        this.field_70180_af.func_187214_a(EXDeath, (Object)false);
    }

    public float func_70047_e() {
        return 1.5f;
    }

    public void func_70014_b(NBTTagCompound p_writeEntityToNBT_1_) {
        super.func_70014_b(p_writeEntityToNBT_1_);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            p_writeEntityToNBT_1_.func_74757_a("powered", true);
        }
        p_writeEntityToNBT_1_.func_74777_a("Fuse", (short)this.fuseTime2);
        p_writeEntityToNBT_1_.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(NBTTagCompound p_readEntityFromNBT_1_) {
        super.func_70037_a(p_readEntityFromNBT_1_);
        this.field_70180_af.func_187227_b(POWERED, (Object)p_readEntityFromNBT_1_.func_74767_n("powered"));
        if (p_readEntityFromNBT_1_.func_150297_b("Fuse", 99)) {
            this.fuseTime2 = p_readEntityFromNBT_1_.func_74765_d("Fuse");
        }
        if (p_readEntityFromNBT_1_.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    private void setEXDeath(boolean a) {
        this.field_70180_af.func_187227_b(EXDeath, (Object)a);
    }

    private boolean getEXDeath() {
        return (Boolean)this.field_70180_af.func_187225_a(EXDeath);
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public void setCreeperState(int i) {
        this.field_70180_af.func_187227_b(STATE, (Object)i);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float tick) {
        return ((float)this.lastActiveTime2 + (float)(this.timeSinceIgnited2 - this.lastActiveTime2) * tick) / (float)(this.fuseTime2 - 20);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity() {
        return ((float)this.lastActiveTime2 + (float)(this.timeSinceIgnited2 - this.lastActiveTime2) * (float)this.tick) / (float)(this.fuseTime2 - 20);
    }

    @Override
    public void spawnDeathLoot() {
        this.getData().spawnDeathLoot((EntityLivingBase)this);
    }

    @Override
    public void spawnMobsInside() {
        this.getData().spawnMobInside((EntityLivingBase)this);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }

    public boolean getEXBurning() {
        return SRPEConfigMobs.EXDeathBurningHijackedCreeper;
    }

    public float getEXChance() {
        return SRPEConfigMobs.chanceEXDeathHijackedCreeper;
    }

    protected void func_70609_aI() {
        block12: {
            block11: {
                int k;
                if (this.cDeath) {
                    this.cDeath = false;
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.getEXBurning() && this.func_70027_ad()) {
                            this.setEXDeath(false);
                        } else {
                            this.setEXDeath(this.field_70146_Z.nextFloat() < this.getEXChance());
                        }
                    }
                }
                if (!this.getEXDeath()) break block11;
                this.lastActiveTime2 = this.timeSinceIgnited2++;
                if (this.timeSinceIgnited2 <= SRPEConfigMobs.fuseTimeHijackedCreeper) break block12;
                if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                    int j;
                    k = this.func_70693_a(this.field_70717_bb);
                    for (k = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)k); k > 0; k -= j) {
                        j = EntityXPOrb.func_70527_a((int)k);
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                    }
                }
                this.field_70729_aU = true;
                this.func_70106_y();
                this.explode(2.0f, this.func_70027_ad() && SRPEConfigMobs.deathSpawnFireHijackedCreeper, false);
                for (k = 0; k < 20; ++k) {
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
                }
                break block12;
            }
            if (++this.field_70725_aQ > 20) {
                int k;
                if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                    int j;
                    k = this.func_70693_a(this.field_70717_bb);
                    for (k = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)k); k > 0; k -= j) {
                        j = EntityXPOrb.func_70527_a((int)k);
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                    }
                }
                this.field_70729_aU = true;
                this.func_70106_y();
                for (k = 0; k < 20; ++k) {
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
                }
            }
        }
    }

    public void explode(float exRadius, boolean fire, boolean destroyBlock) {
        this.func_184185_a(SRPSounds.MOBEXPLOTION, 1.0f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, exRadius, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) && fire, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) && destroyBlock);
            this.spawnLingeringCloud();
            if (this.ex) {
                this.ex = false;
                this.spawnGore();
            }
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (++this.tick > 20) {
                this.tick = 0;
                if (this.field_70146_Z.nextInt(30) == 0) {
                    this.func_70665_d(DamageSource.field_76369_e, 1.0f);
                }
            }
        } else if (this.srpTicks == 5) {
            this.hpAnimation = Math.max(this.func_110143_aJ() / this.func_110138_aP(), 0.5f);
        }
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime2 = this.timeSinceIgnited2;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited2 == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited2 += i;
            if (this.timeSinceIgnited2 < 0) {
                this.timeSinceIgnited2 = 0;
            }
            if (this.timeSinceIgnited2 >= this.fuseTime2) {
                this.timeSinceIgnited2 = this.fuseTime2;
                this.field_70729_aU = true;
                this.func_70106_y();
                this.explode(SRPEConfigMobs.explosionRadiusHijackedCreeper, this.func_70027_ad() && SRPEConfigMobs.deathSpawnFireHijackedCreeper, SRPEConfigMobs.deathDestroyBlockHijackedCreeper);
            }
        }
        super.func_70071_h_();
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float p_fall_1_, float p_fall_2_) {
        super.func_180430_e(p_fall_1_, p_fall_2_);
        this.timeSinceIgnited2 = (int)((float)this.timeSinceIgnited2 + p_fall_1_ * 1.5f);
        if (this.timeSinceIgnited2 > this.fuseTime2 - 5) {
            this.timeSinceIgnited2 = this.fuseTime2 - 5;
        }
    }

    protected boolean func_184645_a(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        ItemStack itemstack = p_processInteract_1_.func_184586_b(p_processInteract_2_);
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(p_processInteract_1_, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            p_processInteract_1_.func_184609_a(p_processInteract_2_);
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                itemstack.func_77972_a(1, (EntityLivingBase)p_processInteract_1_);
                return true;
            }
        }
        return super.func_184645_a(p_processInteract_1_, p_processInteract_2_);
    }

    protected void func_70665_d(DamageSource damageSource, float p_damageEntity_2_) {
        double distance;
        super.func_70665_d(damageSource, p_damageEntity_2_);
        if (!this.field_70170_p.field_72995_K && damageSource.func_76346_g() instanceof EntityPlayer && (distance = (double)this.func_70032_d(damageSource.func_76346_g())) < 10.0 && this.field_70146_Z.nextInt(20) == 0) {
            this.ignite();
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
        }
    }

    public void spawnLingeringCloud() {
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entityareaeffectcloud.func_184483_a(3.5f);
        entityareaeffectcloud.func_184495_b(-0.5f);
        if (this.func_70027_ad()) {
            entityareaeffectcloud.func_184485_d(4);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 8);
        } else {
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
        }
        entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
        entityareaeffectcloud.func_184496_a(new PotionEffect(SRPPotions.COTH_E, 800 + this.field_70146_Z.nextInt(500), this.field_70146_Z.nextInt(3)));
        entityareaeffectcloud.func_184496_a(new PotionEffect(SRPPotions.CORRO_E, 200 + this.field_70146_Z.nextInt(400), this.field_70146_Z.nextInt(2)));
        entityareaeffectcloud.func_184496_a(new PotionEffect(SRPPotions.VIRA_E, 600 + this.field_70146_Z.nextInt(400), this.field_70146_Z.nextInt(3)));
        if (this.field_70146_Z.nextInt(4) == 0) {
            entityareaeffectcloud.func_184496_a(new PotionEffect(SRPPotions.BLEED_E, 100 + this.field_70146_Z.nextInt(200), this.field_70146_Z.nextInt(2)));
        }
        this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.getData().addBaseAttributes((EntityLivingBase)this);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SRPEAI_Swimming((EntityMob)this, 0.2, 0.05f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new SRPEAI_CreeperSwell(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        super.func_184651_r();
    }

    public boolean func_70652_k(Entity target) {
        if (!super.func_70652_k(target)) {
            return false;
        }
        if (target instanceof EntityLivingBase && this.field_70146_Z.nextBoolean()) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20 + this.field_70146_Z.nextInt(60), 0));
        }
        return true;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_getHurtSound_1_) {
        return SRPESounds.HICREEPER_GROWL;
    }

    protected SoundEvent func_184615_bR() {
        return SRPESounds.HICREEPER_DEATH;
    }

    @Override
    public boolean func_70686_a(Class<? extends EntityLivingBase> entityClass) {
        return entityClass == EntityPlayer.class || entityClass == EntityPlayerMP.class;
    }

    public ItemStack getPickedResult(RayTraceResult p_getPickedResult_1_) {
        return new ItemStack(SRPEItems.itemmobspawner_hicreeper);
    }
}

